/*
 * Decompiled with CFR 0.152.
 */
package ru.ulogin.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.webkit.WebView;
import ru.ulogin.sdk.UloginAuthActivity;

public class UloginWebView
extends WebView {
    private final GestureDetector gestureDetector;

    public UloginWebView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new MyGestureListener());
    }

    public UloginWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new MyGestureListener());
    }

    public UloginWebView(Context context) {
        super(context);
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new MyGestureListener());
    }

    private UloginAuthActivity getOwnerActivity(Context c) {
        if (c instanceof Activity) {
            return (UloginAuthActivity)c;
        }
        if (c instanceof ContextWrapper) {
            return this.getOwnerActivity(((ContextWrapper)c).getBaseContext());
        }
        return null;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.gestureDetector.onTouchEvent(event) || super.onTouchEvent(event);
    }

    private class MyGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private MyGestureListener() {
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            float diffX = e2.getX() - e1.getX();
            if (velocityX > 500.0f && diffX > 0.0f && (double)velocityX / Math.sqrt(velocityX * velocityX + velocityY * velocityY) > 0.97) {
                UloginWebView.this.getOwnerActivity(UloginWebView.this.getContext()).closeAuthScreen();
                return true;
            }
            return false;
        }
    }
}

