/*
 * Decompiled with CFR 0.152.
 */
package ru.ulogin.sdk;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.HashMap;
import ru.ulogin.sdk.R;

public class ProviderArrayAdapter
extends ArrayAdapter<String> {
    private final Activity context;
    private final ArrayList<String> codes;
    private final HashMap<String, String> names;
    private String selected = "";
    private Boolean animatedSelected = false;
    private float textOffset = 0.0f;

    public ProviderArrayAdapter(Activity context, ArrayList<String> showProviders) {
        super((Context)context, R.layout.ulogin_provider_list_item, showProviders);
        this.context = context;
        this.names = new HashMap();
        String[] providers = context.getResources().getStringArray(R.array.ulogin_providers);
        String[] provider_names = context.getResources().getStringArray(R.array.ulogin_provider_names);
        if (providers.length != provider_names.length) {
            Log.w((String)"ulogin", (String)"providers and provider_names arrays length differs");
        }
        for (int i = 0; i < providers.length && i < provider_names.length; ++i) {
            this.names.put(providers[i], provider_names[i]);
        }
        this.textOffset = context.getResources().getDimension(R.dimen.ulogin_text_left_margin_wide_list);
        this.codes = new ArrayList();
        for (String x : showProviders) {
            if (this.names.containsKey(x)) {
                this.codes.add(x);
                continue;
            }
            Log.w((String)"ulogin", (String)("Unknown provider name: \"" + x + "\". Ignoring"));
        }
    }

    public void setTextOffset(float newTextOffset) {
        this.textOffset = newTextOffset;
        this.notifyDataSetChanged();
    }

    public float getTextOffset() {
        return this.textOffset;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        View rowView = convertView;
        if (rowView == null) {
            LayoutInflater inflater = this.context.getLayoutInflater();
            rowView = inflater.inflate(R.layout.ulogin_provider_list_item, null, true);
            holder = new ViewHolder();
            holder.textView = (TextView)rowView.findViewById(R.id.label);
            holder.imageView = (ImageView)rowView.findViewById(R.id.icon);
            holder.imageSpacer = (ImageView)rowView.findViewById(R.id.iconSpacer);
            holder.imageView.setTag((Object)holder.textView.getLayoutParams());
            rowView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)rowView.getTag();
        }
        holder.textView.setText((CharSequence)this.names.get(this.codes.get(position)));
        holder.textView.setTag((Object)this.codes.get(position));
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)holder.imageView.getTag();
        params.setMargins((int)this.textOffset, 0, 0, 0);
        holder.textView.setLayoutParams((ViewGroup.LayoutParams)params);
        String s = this.codes.get(position);
        if (s.equals(this.selected)) {
            rowView.setBackgroundColor(this.context.getResources().getColor(R.color.ulogin_green_selector));
            holder.imageSpacer.setVisibility(0);
            if (!this.animatedSelected.booleanValue()) {
                Animation animationFalling = AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.ulogin_show_spacer);
                holder.imageSpacer.startAnimation(animationFalling);
                this.animatedSelected = true;
            }
        } else {
            rowView.setBackgroundColor(0);
            holder.imageSpacer.setVisibility(8);
        }
        holder.imageView.setImageResource(this.context.getResources().getIdentifier("ulogin_" + s, "drawable", this.context.getApplicationInfo().packageName));
        return rowView;
    }

    public void setSelectedId(String selected) {
        this.animatedSelected = this.selected.equals(selected);
        this.selected = selected;
    }

    static class ViewHolder {
        public ImageView imageView;
        public ImageView imageSpacer;
        public TextView textView;

        ViewHolder() {
        }
    }
}

