/*
 * Decompiled with CFR 0.152.
 */
package ru.ulogin.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.ulogin.sdk.ProviderArrayAdapter;
import ru.ulogin.sdk.R;

public class UloginAuthActivity
extends Activity {
    public static final String PROVIDERS = "com.ulogin.sdk.providers";
    public static final String FIELDS = "com.ulogin.sdk.fields";
    public static final String OPTIONAL = "com.ulogin.sdk.optional";
    public static final String USERDATA = "com.ulogin.sdk.userdata";
    public static final String APPLICATION_ID = "com.ulogin.sdk.app_id";
    public static final String SECRET_KEY = "com.ulogin.sdk.secret_key";
    public static final String CLEAN_COOKIES_AFTER_AUTH = "com.ulogin.sdk.clean_cookies";
    protected MyInnerHandler handler = new MyInnerHandler(this);
    private static int minPanelWidth;
    private static int shadowWidth;
    private static int browserWidthPixels;
    private static Boolean browserOpenned;
    private int screenWidth = 0;
    private String fields = "";
    private String optional_fields = "";
    private String applicationId = null;
    private String secretKey = null;
    private Integer animationTime;
    private Boolean cleanCookiesAfterFinishing;
    private Boolean singleProvider;
    private ArrayList<String> providers;
    private String deviceId = null;

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    protected void onCreate(Bundle savedInstanceState) {
        ArrayList optional_fields_array_parameter;
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.ulogin_activity_auth);
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
            window.setStatusBarColor(this.getResources().getColor(R.color.ulogin_header_divider));
        }
        WebView web = (WebView)this.findViewById(R.id.webView);
        web.setWebViewClient((WebViewClient)new MyBrowser());
        web.getSettings().setLoadsImagesAutomatically(true);
        web.getSettings().setJavaScriptEnabled(true);
        web.getSettings().setSupportMultipleWindows(false);
        web.addJavascriptInterface((Object)new WebAppInterface(), "UloginSDK");
        web.requestFocus(130);
        web.getSettings().setBuiltInZoomControls(true);
        Intent callingIntent = this.getIntent();
        this.providers = callingIntent.getStringArrayListExtra(PROVIDERS);
        if (this.providers == null) {
            this.providers = new ArrayList<String>(Arrays.asList(this.getResources().getStringArray(R.array.ulogin_providers)));
        }
        this.singleProvider = this.providers.size() == 1;
        minPanelWidth = this.singleProvider != false ? 0 : (int)this.getResources().getDimension(R.dimen.ulogin_panel_min_width);
        shadowWidth = this.singleProvider != false ? 0 : (int)this.getResources().getDimension(R.dimen.ulogin_shadow_width);
        this.animationTime = this.singleProvider != false ? 0 : this.getResources().getInteger(R.integer.ulogin_animation_time);
        ArrayList<String> allowed_array_list = new ArrayList<String>(Arrays.asList(this.getResources().getStringArray(R.array.ulogin_fields)));
        ArrayList<String> fields_array_parameter = callingIntent.getStringArrayListExtra(FIELDS);
        if (fields_array_parameter == null) {
            fields_array_parameter = new ArrayList<String>(Arrays.asList(this.getResources().getStringArray(R.array.ulogin_fields_default)));
        }
        if ((optional_fields_array_parameter = callingIntent.getStringArrayListExtra(OPTIONAL)) != null) {
            for (String s : optional_fields_array_parameter) {
                if (!allowed_array_list.contains(s)) {
                    Log.w((String)"ulogin.sdk.init", (String)("Unknown optional data field \"" + s + "\". Ignoring"));
                    continue;
                }
                if (fields_array_parameter.contains(s)) {
                    Log.w((String)"ulogin.sdk.init", (String)("Data field \"" + s + "\" is already marked as mandatory. Now marking it as optional"));
                    fields_array_parameter.remove(s);
                }
                this.optional_fields = this.optional_fields + (this.optional_fields.length() > 0 ? "," : "") + s;
            }
        }
        this.fields = "";
        for (String s : fields_array_parameter) {
            if (!allowed_array_list.contains(s)) {
                Log.w((String)"ulogin.sdk.init", (String)("Unknown mandatory data field \"" + s + "\". Ignoring"));
                continue;
            }
            this.fields = this.fields + (this.fields.length() > 0 ? "," : "") + s;
        }
        this.applicationId = callingIntent.getStringExtra(APPLICATION_ID);
        if (this.applicationId == null || this.applicationId.length() == 0) {
            this.applicationId = "";
        }
        this.secretKey = callingIntent.getStringExtra(SECRET_KEY);
        if (this.secretKey == null || this.secretKey.length() == 0) {
            this.secretKey = "";
        }
        this.cleanCookiesAfterFinishing = callingIntent.getBooleanExtra(CLEAN_COOKIES_AFTER_AUTH, false);
        ListView providerListView = (ListView)this.findViewById(R.id.providerListView);
        if (this.singleProvider.booleanValue()) {
            providerListView.setVisibility(8);
            ViewGroup webLayer = (ViewGroup)this.findViewById(R.id.webLayer);
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)webLayer.getLayoutParams();
            lp.width = -1;
            webLayer.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.selectProvider(null);
        } else {
            ProviderArrayAdapter adapt = new ProviderArrayAdapter(this, this.providers);
            providerListView.setAdapter((ListAdapter)adapt);
            providerListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View itemClicked, int position, long id2) {
                    UloginAuthActivity.this.selectProvider((ViewGroup)itemClicked);
                }
            });
        }
        this.resizeLayout();
    }

    private void resizeLayout() {
        WindowManager manager = (WindowManager)this.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        manager.getDefaultDisplay().getMetrics(metrics);
        if (!this.singleProvider.booleanValue()) {
            browserWidthPixels = (int)((float)(metrics.widthPixels - minPanelWidth) / metrics.density);
            this.screenWidth = metrics.widthPixels;
            ViewGroup webLayer = (ViewGroup)this.findViewById(R.id.webLayer);
            ListView providerListView = (ListView)this.findViewById(R.id.providerListView);
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)webLayer.getLayoutParams();
            lp.width = this.screenWidth - minPanelWidth;
            webLayer.setLayoutParams((ViewGroup.LayoutParams)lp);
            LinearLayout.LayoutParams layoutParams1 = new LinearLayout.LayoutParams(browserOpenned != false ? minPanelWidth : this.screenWidth + shadowWidth, -1);
            providerListView.setLayoutParams((ViewGroup.LayoutParams)layoutParams1);
        }
    }

    protected void selectProvider(ViewGroup item) {
        ListView providerListView = (ListView)this.findViewById(R.id.providerListView);
        ProviderArrayAdapter adapter = (ProviderArrayAdapter)providerListView.getAdapter();
        Resources resources = this.getResources();
        if (item != null || this.singleProvider.booleanValue()) {
            String applicationName;
            String providerName;
            ((TextView)this.findViewById(R.id.header)).setText((CharSequence)resources.getString(R.string.ulogin_authorize));
            providerListView.setVerticalScrollBarEnabled(false);
            if (this.singleProvider.booleanValue()) {
                providerName = this.providers.get(0);
            } else {
                providerName = item.findViewById(R.id.label).getTag().toString();
                ((ProviderArrayAdapter)providerListView.getAdapter()).setSelectedId(providerName);
            }
            CharSequence appName = resources.getText(resources.getIdentifier("app_name", "string", this.getPackageName()));
            try {
                applicationName = URLEncoder.encode(appName.toString(), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                applicationName = appName.toString();
            }
            catch (Resources.NotFoundException e) {
                applicationName = appName.toString();
            }
            if (this.deviceId == null) {
                TelephonyManager tManager = (TelephonyManager)this.getSystemService("phone");
                this.deviceId = tManager.getDeviceId() + "_" + Settings.Secure.getString((ContentResolver)this.getContentResolver(), (String)"android_id");
            }
            String url = "https://ulogin.ru/auth.php?name=" + providerName + "&app_name=" + applicationName + "&app_id=" + this.applicationId + "&secret_key=" + this.secretKey + "&mid=" + this.deviceId + "&lang=" + this.getResources().getConfiguration().locale.getLanguage() + "&fields=" + this.fields + "&optional=" + this.optional_fields + "&verify=" + "&window=3&source=android&host=ulogin.ru&redirect_uri=&callback=ucall&screen=&providers=&q=https://ulogin.ru/android_sdk.php";
            WebView web = (WebView)this.findViewById(R.id.webView);
            web.loadUrl(url);
            if (!browserOpenned.booleanValue() && !this.singleProvider.booleanValue()) {
                browserOpenned = true;
                ViewGroup webLayer = (ViewGroup)this.findViewById(R.id.webLayer);
                ExpandAnimation a = new ExpandAnimation(minPanelWidth, (View)providerListView);
                a.setDuration(this.animationTime.intValue());
                a.start();
                webLayer.startAnimation((Animation)a);
            }
        } else {
            ((TextView)this.findViewById(R.id.header)).setText((CharSequence)resources.getString(R.string.ulogin_select_provider));
            providerListView.setVerticalScrollBarEnabled(true);
            ((ProviderArrayAdapter)providerListView.getAdapter()).setSelectedId("");
            if (browserOpenned.booleanValue()) {
                browserOpenned = false;
                ExpandAnimation a = new ExpandAnimation(this.screenWidth + shadowWidth, (View)providerListView);
                a.setDuration(this.animationTime.intValue());
                ViewGroup webLayer = (ViewGroup)this.findViewById(R.id.webLayer);
                webLayer.startAnimation((Animation)a);
            }
        }
        if (!this.singleProvider.booleanValue()) {
            adapter.notifyDataSetChanged();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.resizeLayout();
    }

    private void goBack() {
        if (browserOpenned.booleanValue() && !this.singleProvider.booleanValue()) {
            this.closeAuthScreen();
        } else {
            this.sendResult(null);
        }
    }

    public void closeAuthScreen() {
        if (browserOpenned.booleanValue() && !this.singleProvider.booleanValue()) {
            this.selectProvider(null);
        }
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.goBack();
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    protected void sendResult(HashMap<String, String> result) {
        int res;
        if (result != null && this.cleanCookiesAfterFinishing.booleanValue()) {
            CookieManager cookieManager = CookieManager.getInstance();
            cookieManager.removeAllCookie();
        }
        browserOpenned = false;
        int n = res = result != null && result.get("error") == null ? -1 : 0;
        if (result == null) {
            result = new HashMap();
            result.put("error", "canceled");
        }
        Intent intent = new Intent();
        intent.putExtra(USERDATA, result);
        this.setResult(res, intent);
        this.finish();
    }

    static {
        browserOpenned = false;
    }

    public class ExpandAnimation
    extends Animation {
        private final float aPanelStartWidth;
        private final float aPanelEndWidth;
        private final float aDeltaWidth;
        private final View aPanel;
        private final ProviderArrayAdapter aAdapter;
        private final float a_ulogin_text_delta_margin;
        private float a_start_ulogin_text_margin;

        ExpandAnimation(float endWidth, View panel) {
            this.aPanel = panel;
            this.aPanelStartWidth = panel.getWidth();
            this.aPanelEndWidth = endWidth;
            this.aDeltaWidth = this.aPanelEndWidth - this.aPanelStartWidth;
            this.aAdapter = (ProviderArrayAdapter)((ListView)panel).getAdapter();
            Resources res = panel.getContext().getResources();
            this.a_start_ulogin_text_margin = this.aAdapter.getTextOffset();
            float endOffset = this.aDeltaWidth > 0.0f ? res.getDimension(R.dimen.ulogin_text_left_margin_wide_list) : res.getDimension(R.dimen.ulogin_text_left_margin_panel);
            this.a_ulogin_text_delta_margin = endOffset - this.a_start_ulogin_text_margin;
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            LinearLayout.LayoutParams layoutParams1 = new LinearLayout.LayoutParams((int)(this.aPanelStartWidth + this.aDeltaWidth * interpolatedTime), -1);
            this.aPanel.setLayoutParams((ViewGroup.LayoutParams)layoutParams1);
            this.aAdapter.setTextOffset((int)(this.a_start_ulogin_text_margin + this.a_ulogin_text_delta_margin * interpolatedTime));
        }

        public boolean willChangeBounds() {
            return true;
        }
    }

    private static class MyInnerHandler
    extends Handler {
        WeakReference<UloginAuthActivity> mFrag;
        Boolean resultReady = false;
        Boolean authCancelled = false;

        MyInnerHandler(UloginAuthActivity aFragment) {
            this.mFrag = new WeakReference<UloginAuthActivity>(aFragment);
        }

        public void handleMessage(Message message) {
            UloginAuthActivity theFrag = (UloginAuthActivity)((Object)this.mFrag.get());
            String data = (String)message.obj;
            CookieManager cookieManager = CookieManager.getInstance();
            switch (message.what) {
                case 1: {
                    this.resultReady = data.contains("android_sdk.php");
                    this.authCancelled = data.contains("://ulogin.ru/auth.php") && data.contains("error=access_denied");
                    break;
                }
                case 2: {
                    if (this.authCancelled.booleanValue()) {
                        theFrag.goBack();
                        return;
                    }
                    if (!this.resultReady.booleanValue() || !data.startsWith("<!--")) break;
                    data = data.replace("<!--", "").replace("-->", "");
                    HashMap<String, String> result = new HashMap<String, String>();
                    String delCookiesDomain = "";
                    JSONArray delCookiesList = null;
                    try {
                        JSONObject obj = new JSONObject(data);
                        Iterator keys = obj.keys();
                        block16: while (keys.hasNext()) {
                            String key;
                            switch (key = (String)keys.next()) {
                                case "delcookies_url": {
                                    delCookiesDomain = obj.getString(key);
                                    continue block16;
                                }
                                case "delcookies": {
                                    delCookiesList = obj.getJSONArray(key);
                                    continue block16;
                                }
                            }
                            result.put(key, obj.getString(key));
                        }
                    }
                    catch (Exception je) {
                        Log.e((String)"ulogin.sdk.response", (String)"Error parsing JSON response");
                        result.put("error", "Error parsing response");
                    }
                    try {
                        if (delCookiesDomain.length() > 0 && delCookiesList != null) {
                            for (int i = 0; i < delCookiesList.length(); ++i) {
                                cookieManager.setCookie(delCookiesDomain, delCookiesList.getString(i));
                            }
                        }
                    }
                    catch (Exception je) {
                        // empty catch block
                    }
                    theFrag.sendResult(result);
                    this.resultReady = false;
                }
            }
        }
    }

    private class WebAppInterface {
        private WebAppInterface() {
        }

        @JavascriptInterface
        public void getJSON(String url, String html) {
            Message msg = new Message();
            msg.what = 1;
            msg.obj = url;
            UloginAuthActivity.this.handler.sendMessage(msg);
            Message msg1 = new Message();
            msg1.what = 2;
            msg1.obj = html;
            UloginAuthActivity.this.handler.sendMessage(msg1);
        }

        @JavascriptInterface
        public void close() {
            UloginAuthActivity.this.closeAuthScreen();
        }
    }

    private class MyBrowser
    extends WebViewClient {
        private boolean loadingFinished = true;
        private boolean redirect = false;

        private MyBrowser() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (!this.loadingFinished) {
                this.redirect = true;
            }
            this.loadingFinished = false;
            if (url.startsWith("https://ulogin.ru/")) {
                view.getSettings().setLoadWithOverviewMode(true);
                view.getSettings().setUseWideViewPort(true);
            } else {
                view.getSettings().setLoadWithOverviewMode(false);
                view.getSettings().setUseWideViewPort(false);
            }
            view.loadUrl(url);
            return true;
        }

        public void onPageStarted(WebView view, String url, Bitmap facIcon) {
            this.loadingFinished = false;
            UloginAuthActivity.this.findViewById(R.id.loadingPanel).setVisibility(0);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            Toast.makeText((Context)UloginAuthActivity.this.getApplicationContext(), (CharSequence)(description + " " + UloginAuthActivity.this.getResources().getString(R.string.ulogin_no_connection) + "."), (int)0).show();
            UloginAuthActivity.this.closeAuthScreen();
        }

        public void onPageFinished(WebView view, String url) {
            if (!this.redirect) {
                this.loadingFinished = true;
                UloginAuthActivity.this.findViewById(R.id.loadingPanel).setVisibility(8);
            }
            super.onPageFinished(view, url);
            if (this.loadingFinished && !this.redirect) {
                view.loadUrl("javascript:window.UloginSDK.getJSON(document.location.toString(),document.getElementsByTagName('html')[0].innerHTML);");
                view.loadUrl("javascript:var scale = " + browserWidthPixels + " / document.body.scrollWidth; if(scale>0.6 && scale<2) {document.body.style.zoom = scale;}");
            } else {
                this.redirect = false;
            }
        }
    }
}

